/* A random-movement automatic player. */

#include "game.h"

static rand_state_t r;

static int contest(player_t *p1, player_t *p2);

void init_move()
{
  int mix;
  mix = (int)time(NULL);
  bsd_srand(mix, &r);
}

void auto_move(player_t *p) 
{
  player_t *p2;
  int x, y;

  while (1) {
    x = p->field_x;
    y = p->field_y;
    switch (bsd_rand(4, &r)) {
    case 0: x++; break;
    case 1: --x; break;
    case 2: y++; break;
    case 3: y--; break;
    }

    if ((x >= 0) && (x < HSIZE)
        && (y >= 0) && (y < VSIZE)) {

      if (s.field[y][x])
        p2 = site_to_player(s.field[y][x]);
      else
        p2 = NULL;

      if (!p2) {
        /* move */
        move_player(p, y, x);
      } else {
        if ((p->ball != -1) && (p->team == p2->team) 
            && (p2->ball == -1)) {
          /* try to pass */
          if (contest(p, p2)) {
            /* a pass */
            move_ball(p, p2, 1);
          }
        } else if ((p->ball == -1) && (p->team != p2->team) 
                   && (p2->ball != -1)) {
          /* try to steal... */
          if (contest(p, p2)) {
            /* a steal */
            move_ball(p2, p, 0);
          }
        } else {
          /* bump */
          move_none();
        }
      }
      break;
    }
  }
}

static int contest(player_t *p1, player_t *p2)
/* Generate a bunch of random numbers to determine whether a
   pass/steal succeeds. (Simulates a more interesting calculation that
   a real game might use.) */
{
  int c1 = 0, c2 = 0;

  while ((c1 < 10000) && (c2 < 10000)) {
    if (bsd_rand(100, &r) > bsd_rand(100, &r))
      c1++;
    else
      c2++;
  }

  return (c1 > c2);
}
