/* Initializes the field, either to a fix state if we start out as the
   coordinator, or by getting the initial field state from the
   coordinator using get_field_state(). */

#include "game.h"

void init_field()
{
  int i;

  find_coordinator();
  
  if (me != coordinator) {
    get_field_state();
  }

  if (me == coordinator) {
    /* Put players on the field: */
    for (i = 0; i < NUM_PLAYERS; i++) {
      s.red[i].site = RED_START_SITE + i;
      s.red[i].field_x = i;
      s.red[i].field_y = 0;
      s.red[i].team = RED_TEAM;
      s.red[i].ball = -1;
      
      s.field[0][i] = s.red[i].site;

      s.blue[i].site = BLUE_START_SITE + i;
      s.blue[i].field_x = i;
      s.blue[i].field_y = VSIZE-1;
      s.blue[i].team = BLUE_TEAM;
      s.blue[i].ball = -1;

      s.field[VSIZE-1][i] = s.blue[i].site;
    }

    /* Give one ball to each team: */
    s.ball[0].carried_by = RED_START_SITE;
    s.ball[1].carried_by = BLUE_START_SITE;
    for (i = 0; i < NUM_BALLS; i++) {
      player_t *p = site_to_player(s.ball[i].carried_by);
      p->ball = i;
      s.ball[i].field_x = p->field_x;
      s.ball[i].field_y = p->field_y;
    }
  }
}
