#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <errno.h>
#include <ctype.h>
#include <time.h>
#include "rand.h"

#define HSIZE 24
#define VSIZE 10

#define RED_TEAM 0
#define BLUE_TEAM 1

#define NUM_PLAYERS 2
#define NUM_BALLS 2

/* Each site represents a player: referee, red, or blue.  Site 0 is
   the refereee. Site 1 starts the red team, etc. */
#define REFEREE_SITE 0
#define RED_START_SITE 1
#define BLUE_START_SITE (RED_START_SITE + NUM_PLAYERS)

typedef struct site_t {
  char host[256];
  int portno;
  struct sockaddr_in addr;
} site_t;

#define NUM_SITES (1 + 2*NUM_PLAYERS)
extern site_t site[NUM_SITES];

extern int me, coordinator;


typedef struct player_t {
  int site;
  int team;
  int field_x, field_y;
  int ball; /* -1 => not carrying a ball */
} player_t;

typedef struct ball_t {
  int field_x, field_y;
  int carried_by; /* -1 => directly on field */
} ball_t;

/* The state of the game --- no pointers, so it
   can easily be shipped among sites. */
typedef struct state_t {
  int passes[2];
  int steals[2];
  int moves;
  char field[VSIZE][HSIZE]; /* 0 => empty, other => site */
  player_t red[NUM_PLAYERS];
  player_t blue[NUM_PLAYERS];
  player_t referee;
  ball_t ball[NUM_BALLS];
} state_t;

extern state_t s;

int have_lock;

void load_sites(int argc, char **argv);
int address_to_site(struct sockaddr_in *addr);
player_t *site_to_player(int site);
void init_field();
void show_field();
void init_move();
void auto_move(player_t *p);

void move_player(player_t *p, int y, int x);
void move_ball(player_t *p, player_t *p2, int pass);
void move_none();

void find_coordinator();
int get_field_lock();
int get_field_state();
int put_field_lock();
int put_field_state();
void cooperate();

void init_msg();
void *recv_msg(int *from, int *tag, int *sz, double timeout);
void send_msg(int to, int tag, int sz, void *data);
void broadcast_msg(int tag, int sz, void *data);
