/* All changes to the game state happen here, instead of in "auto.c".
   This implementation works directly on the local game state, but it
   could conceivably send messages, instead. */

#include "game.h"

void move_player(player_t *p, int y, int x)
{
  s.field[p->field_y][p->field_x] = 0;
  s.field[y][x] = p->site;
  p->field_x = x;
  p->field_y = y;
  if (p->ball != -1) {
    s.ball[p->ball].field_x = x;
    s.ball[p->ball].field_y = y;
  }
  s.moves++;
}

void move_ball(player_t *p, player_t *p2, int pass)
{
  p2->ball = p->ball;
  s.ball[p->ball].field_x = p2->field_x;
  s.ball[p->ball].field_y = p2->field_y;
  s.ball[p->ball].carried_by = p2->site;
  p->ball = -1;
  if (pass)
    s.passes[p->team]++;
  else
    s.steals[p2->team]++;
  s.moves++;
}

void move_none()
{
  s.moves++;
}
