/* This file provides basic message utilities in terms of UDP.
   For the functions exported by list library, communication is
   in terms of site numbers, instead of IP addresses. */

#include "game.h"
#include <sys/select.h>
#include <math.h>

#define BUFFER_SIZE 4096

static int sock;
static char buffer[BUFFER_SIZE];

void init_msg()
{
  sock = socket(AF_INET, SOCK_DGRAM, getprotobyname("udp")->p_proto);

  if (sock < 0) {
    perror("socket creation failed");
    abort();
  }

  if (bind(sock, (struct sockaddr *)&site[me].addr, sizeof(site[me].addr))) {
    perror("bind failed");
    abort();
  }
}

void *recv_msg(int *from, int *tag, int *sz, double timeout)
{
  struct sockaddr_in from_addr;
  socklen_t from_len;
  int amt;
  fd_set rds;
  struct timeval tv = { (int)timeout, (int)fmod(timeout, 1.0) * 100000};

  FD_ZERO(&rds);
  FD_SET(sock, &rds);
  if (!select(sock+1, &rds, NULL, NULL, (timeout == 0.0) ? NULL : &tv))
    return NULL;

  from_len = sizeof(from_addr);
  amt = recvfrom(sock, buffer, BUFFER_SIZE, 0,
                 (struct sockaddr *)&from_addr, &from_len);
  if (amt < 0) {
    perror("recvfrom failed");
    abort();
  }

  *tag = *(int *)buffer;
  *sz = amt - sizeof(int);
  *from = address_to_site(&from_addr);

  return buffer + sizeof(int);
}

void send_msg(int to, int tag, int sz, void *data)
{
  int amt;

  if (sz + sizeof(int) > BUFFER_SIZE) {
    fprintf(stderr, "message size %d too large\n", sz);
    abort();
  }
    
  memcpy(buffer + sizeof(int), data, sz);
  *(int *)buffer = tag;

  amt = sendto(sock, buffer, sz + sizeof(int), 0,
               (struct sockaddr *)&site[to].addr, sizeof(site[to].addr));
  if (amt < 0) {
    perror("sendto failed");
    abort();
  }
}

void broadcast_msg(int tag, int sz, void *data)
{
  int i;

  for (i = 0; i < NUM_SITES; i++) {
    if (i != me)
      send_msg(i, tag, sz, data);
  }
}

