/* Prints the game state and performs invariant checks. */

#include "game.h"

void show_field()
{
  int i, j;

  printf("\nMoves: %d  Red passes+steals: %d+%d  Blue passes+steals: %d+%d\n", 
         s.moves, 
         s.passes[RED_TEAM], s.steals[RED_TEAM], 
         s.passes[BLUE_TEAM], s.steals[BLUE_TEAM]);
  for (i = 0; i < VSIZE; i++) {
    for (j = 0; j < HSIZE; j++) {
      if (s.field[i][j]) {
        player_t *p = site_to_player(s.field[i][j]);
        char c;
        c = ((p->team == RED_TEAM) ? 'r' : 'b');
        if (p->ball != -1)
          c = toupper(c);
        printf("%c", c);
        /* Sanity check: */
        if (p->ball != -1)
          if (s.ball[p->ball].carried_by != p->site) {
            fprintf(stderr, "Player has ball, but ball doesn't refer to player\n");
            abort();
          }
      } else
        printf("_");
    }
    printf("\n");
  }

  /* More sanity checks: */
  for (i = 0; i < NUM_PLAYERS; i++) {
    if (s.field[s.red[i].field_y][s.red[i].field_x] != s.red[i].site) {
      fprintf(stderr, "A red player's position doesn't match the field\n");
      abort();
    }
    if (s.field[s.blue[i].field_y][s.blue[i].field_x] != s.blue[i].site) {
      fprintf(stderr, "A blue player's position doesn't match the field\n");
      abort();
    }
  }
  for (i = 0; i < NUM_BALLS; i++) {
    if (site_to_player(s.ball[i].carried_by)->ball != i) {
      fprintf(stderr, "Ball's carrier does not refer to ball\n");
      abort();
    }
    if ((s.ball[i].field_x != site_to_player(s.ball[i].carried_by)->field_x)
        || (s.ball[i].field_y != site_to_player(s.ball[i].carried_by)->field_y)) {
      fprintf(stderr, "Ball is not at its carrier's position\n");
      abort();
    }
  }
}
