/* This file reads the site addresses form "site.txt"
   to fill in the `site' array. The addresses are used in
   the "msg.c" library. */

#include "game.h"

static void fill_address(char *host, int portno, struct sockaddr_in *addr)
{
  struct hostent *server;

  server = gethostbyname(host);
  if (!server) {
    fprintf(stderr, 
            "could not resolve hostname: %s (%s)\n",
            host,
            strerror(errno));
    abort();
  }
                
  memset(addr, 0, sizeof(*addr));
  addr->sin_family = AF_INET;
  memcpy(&addr->sin_addr.s_addr, server->h_addr, server->h_length);
  addr->sin_port = htons(portno);
}

static void read_site(FILE *f, const char *desc, int site_no)
{
  fscanf(f, "%s %d\n", site[site_no].host, &site[site_no].portno);
  printf("%s%s = %s at %d\n", 
         desc, ((site_no == me) ? " (me)" : ""), 
         site[site_no].host, site[site_no].portno);
  fill_address(site[site_no].host, site[site_no].portno, &site[site_no].addr);
}

void load_sites(int argc, char **argv)
{
  char buffer[32];
  FILE *f;
  int i, site_no = 0;

  if (argc != 2) {
    fprintf(stderr, 
            "%s: expected site number as command-line argument\n",
            argv[0]);
    abort();
  }

  me = atoi(argv[1]);
  if ((me < 0) || (me > (NUM_PLAYERS * 2))) {
    fprintf(stderr, 
            "%s: bad site number: %s\n",
            argv[0],
            argv[1]);
    abort();
  }

  f = fopen("sites.txt", "r");
  if (!f) {
    fprintf(stderr, "cannot read \"sites.txt\"\n");
    abort();
  }

  read_site(f, "Referee", site_no++);
  
  for (i = 0; i < NUM_PLAYERS; i++) {
    sprintf(buffer, "Red player %d", i);
    read_site(f, buffer, site_no++);
  }
  for (i = 0; i < NUM_PLAYERS; i++) {
    sprintf(buffer, "Blue player %d", i);
    read_site(f, buffer, site_no++);
  }

  fclose(f);
}

int address_to_site(struct sockaddr_in *addr)
{
  int i;

  for (i = 0; i < NUM_SITES; i++)  {
    if (!memcmp(&addr->sin_addr.s_addr, 
                &site[i].addr.sin_addr.s_addr,
                sizeof(addr->sin_addr.s_addr))
        && (addr->sin_port == site[i].addr.sin_port))
      return i;
  }

  fprintf(stderr, "could not determine site from address\n");
  abort();
}
