#include <pthread.h>
#include <stdlib.h>
#include <string.h>
#include "dsm.h"

#define NUM_SITES 9
#define NUM_SEMAS 12

void *dsm_malloc(int size)
{
  void *p;
  p = malloc(size);
  memset(p, 0, size);
  return p;
}

/* **************************************** */

typedef struct sema_t {
  int ready;
  pthread_mutex_t m;
  pthread_cond_t c;
} sema_t;

static void sema_wait(sema_t *s)
{
  pthread_mutex_lock(&s->m);
  while (!s->ready) {
    pthread_cond_wait(&s->c, &s->m);
  }
  --s->ready;
  pthread_mutex_unlock(&s->m);
}

static void sema_signal(sema_t *s)
{
  pthread_mutex_lock(&s->m);
  s->ready++;
  pthread_cond_signal(&s->c);
  pthread_mutex_unlock(&s->m);
}

static void sema_init(sema_t *s, int state)
{
  pthread_mutex_init(&s->m, NULL);
  pthread_cond_init(&s->c, NULL);
  s->ready = state;
}

/* **************************************** */

static sema_t semas[NUM_SEMAS];
static int sema_counter;

void dsm_sema_init(dsm_sema_t *t, int state)
{
  int n = sema_counter++;
  sema_init(&semas[n], state);
  *t = n;
}

void dsm_sema_wait(dsm_sema_t *t)
{
  sema_wait(&semas[*t]);
}

void dsm_sema_signal(dsm_sema_t *t)
{
  sema_signal(&semas[*t]);
}

/* **************************************** */

static void *run_site(void *p)
{
  site_main(*(int *)p);
  return NULL;
}

int main()
{
  int i;
  int ids[NUM_SITES];
  pthread_t th[NUM_SITES];

  /* Memory simply shared, so call dsm_init() only once: */
  site_init();

  /* Run each site in a pthread: */
  for (i = 0; i < NUM_SITES; i++) {
    ids[i] = i;
    pthread_create(&th[i], NULL, run_site, &ids[i]);
  }

  /* Wait for all to complete: */
  for (i = 0; i < NUM_SITES; i++) {
    pthread_join(th[i], NULL);
  }

  return 1;
}
