#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "sites.h"

static void read_all(int fd, void *b, int sz);

int main(int argc, char **argv, char **envp)
{
  int i, len;
  pid_t pid, serv_pid;
  char *args[5], buffer[32], buffer2[32], prog[256];
  int p[2];

  pipe(p);

  sprintf(prog, "%s_dsm_server", argv[1]);
  serv_pid = fork();
  if (!serv_pid) {
    args[0] = prog;
    args[1] = "40000";
    args[2] = NULL;

    /* redirected stdout */
    dup2(p[1], 1);
    
    execve(args[0], args, envp);
    
    perror("execve failed");
    abort();
  }

  sprintf(prog, "%s_dsm_client", argv[1]);
  for (i = 0; i < NUM_SITES; i++) {
    /* wait for "ready <n>" printout from the server: */
    len = 6 + 1 + (i >= 10 ? 1 : 0) + 1;
    read_all(p[0], buffer, len);
    sprintf(buffer2, "ready %d\n", i);
    if (memcmp(buffer, buffer2, len)) {
      buffer2[len] = 0;
      fprintf(stderr, "unexpected output from server for %d: %s\n", 
              i, buffer);
      abort();
    }

    pid = fork();
    if (!pid) {
      args[0] = prog;
      sprintf(buffer, "%d", i);
      args[1] = buffer;
      args[2] = "localhost";
      args[3] = "40000";
      args[4] = NULL;

      execve(args[0], args, envp);

      perror("execve failed");
      abort();
    }
    usleep(10000);
  }

  waitpid(serv_pid, &i, 0);

  return i;
}

void read_all(int fd, void *b, int sz)
{
  int amt;

  while (sz) {
    amt = read(fd, b, sz);
    if (amt < 0) {
      perror("read failed");
      abort();
    }
    sz -= amt;
    b = (char *)b + amt;
  }
}


