#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <netdb.h>
#include <sys/socket.h>
#include "network_dsm.h"

void read_all(int fd, void *b, int sz)
{
  int amt;

  while (sz) {
    amt = read(fd, b, sz);
    if (amt < 0) {
      perror("read failed");
      abort();
    }
    sz -= amt;
    b = (char *)b + amt;
  }
}

void write_all(int fd, void *b, int sz)
{
  int amt;

  while (sz) {
    amt = write(fd, b, sz);
    if (amt < 0) {
      perror("write failed");
      abort();
    }
    sz -= amt;
    b = (char *)b + amt;
  }
}

int *start_server(char *servport, int num_sites)
{
  int reuse = 1, portno, *fds, lfd;
  struct sockaddr_in serv_addr;
  int i;
  unsigned int len;
  struct sockaddr_in addr;

  portno = atoi(servport);

  lfd = socket(AF_INET, SOCK_STREAM, 0);

  memset(&serv_addr, 0, sizeof(serv_addr));

  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = INADDR_ANY;
  serv_addr.sin_port = htons(portno);

  setsockopt(lfd, SOL_SOCKET, SO_REUSEADDR, (char *)(&reuse), sizeof(int));

  if (bind(lfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr))) {
    perror("bind failed");
    abort();
  }

  if (listen(lfd, 5)) {
    perror("listen failed");
    abort();
  }

  fds = (int *)malloc(sizeof(int) * num_sites);

  for (i = 0; i < num_sites; i++) {
    printf("ready %d\n", i);
    fflush(stdout);
    fds[i] = accept(lfd, (struct sockaddr *)&addr, &len);
  }

  return fds;
}

int start_client(char *hostname, char *hostport, int id)
{
  int portno, fd;
  struct hostent *server;
  struct sockaddr_in serv_addr;
  
  server = gethostbyname(hostname);
  portno = atoi(hostport);
                
  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  memcpy(&serv_addr.sin_addr.s_addr, server->h_addr, server->h_length);
  serv_addr.sin_port = htons(portno);
  
  fd = socket(PF_INET, SOCK_STREAM, getprotobyname("tcp")->p_proto);
  if (connect(fd, (const struct sockaddr *)&serv_addr, sizeof(serv_addr))) {
    perror("connect failed");
    abort();
  }

  return fd;
}
