#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <netdb.h>
#include <sys/socket.h>
#include "network_dsm.h"

static int the_id;

void read_all(int fd, void *b, int sz)
{
  int amt;

  while (sz) {
    amt = recv(fd, b, sz, 0);
    if (amt < 0) {
      perror("recv failed");
      abort();
    } else {
      send(fd, "ack!", 4, 0);
      sz -= amt;
      b = (char *)b + amt;
    }
  }
}

void write_all(int fd, void *b, int sz)
{
  int amt, try_sz = sz;
  char buffer[4];

  while (sz) {
    amt = send(fd, b, try_sz, 0);
    if (amt < 0) {
      if (errno == EMSGSIZE) {
        try_sz /= 2;
      } else {
        perror("send failed");
        abort();
      }
    } else {
      /* we need an ACK to make sure that messages are recieved in
         order: */
      if ((recv(fd, buffer, 4, 0) != 4)
          || memcmp(buffer, "ack!", 4)) {
        fprintf(stderr, "bad ACK: %4.4s\n", buffer);
        abort();
      }
      sz -= amt;
      b = (char *)b + amt;
      try_sz = sz;
    }
  }
}

static void do_connect(int fd, char *hostname, int portno)
{
  struct hostent *server;
  struct sockaddr_in serv_addr;

  server = gethostbyname(hostname);
                
  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  memcpy(&serv_addr.sin_addr.s_addr, server->h_addr, server->h_length);
  serv_addr.sin_port = htons(portno);
  
  if (connect(fd, (const struct sockaddr *)&serv_addr, sizeof(serv_addr))) {
    perror("client connect failed");
    abort();
  }
}

static void do_bind(int fd, int portno)
{
  struct sockaddr_in serv_addr;

  memset(&serv_addr, 0, sizeof(serv_addr));
  
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = INADDR_ANY;
  serv_addr.sin_port = htons(portno);

  if (bind(fd, (struct sockaddr *)&serv_addr, sizeof(serv_addr))) {
    perror("bind failed");
    abort();
  }
}

int *start_server(char *servport, int num_sites)
{
  int portno, *fds, lfd;
  int i, buffer[1];

  portno = atoi(servport);

  fds = (int *)malloc(sizeof(int) * num_sites);

  for (i = 0; i < num_sites; i++) {
    lfd = socket(AF_INET, SOCK_DGRAM, getprotobyname("udp")->p_proto);
    
    do_bind(lfd, portno + i);

    printf("ready %d\n", i);
    fflush(stdout);
    
    if (recv(lfd, buffer, sizeof(int), 0) != sizeof(int)) {
      perror("initial recv failed");
      abort();
    }

    /* Assume that clients run on the same machine: */
    do_connect(lfd, "localhost", portno + i + 100);

    fds[i] = lfd;
  }

  return fds;
}

int start_client(char *hostname, char *hostport, int id)
{
  int portno, fd;

  fd = socket(PF_INET, SOCK_DGRAM, getprotobyname("udp")->p_proto);
  portno = atoi(hostport) + id;

  do_bind(fd, portno + 100);

  do_connect(fd, hostname, portno);

  if (send(fd, &id, sizeof(int), 0) != sizeof(int)) {
    perror("connecting send failed");
    abort();
  }

  the_id = id + 1;

  return fd;
}
