#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

int main()
{
  int fd, fd2;
  pid_t pid;
  off_t pos;
  char buffer[32];


  fd = open("temp", O_RDWR | O_CREAT, 0666);
  link("temp", "temp2"); /* hard link */
  fd2 = open("temp2", O_RDWR);

  write(fd, "abcde", 5);

  read(fd2, buffer, 2);
  printf("got %2.2s\n", buffer);

  lseek(fd, 3, SEEK_SET);
  lseek(fd2, 1, SEEK_SET);

  pos = lseek(fd, 0, SEEK_CUR);
  printf("fd at %ld\n", (long)pos);

  pos = lseek(fd2, 0, SEEK_CUR);
  printf("fd2 at %ld\n", (long)pos);

  pid = fork();
  if (!pid) {
    write(fd, "fghi", 4);
    return 0;
  } else {
    int status;
    waitpid(pid, &status, 0);

    pos = lseek(fd, 0, SEEK_CUR);
    printf("fd now at %ld\n", (long)pos);

    pos = lseek(fd2, 0, SEEK_CUR);
    printf("fd2 now at %ld\n", (long)pos);

    read(fd2, buffer, 4);
    printf("got %4.4s\n", buffer);
  }

  unlink("temp");
  unlink("temp2");
}
