/* Asynchronous output with polling for completion. Ouput and
   computation can be in parallel, but reading and wriing whole chunks
   makes it not interactive. */

#include "utils.h"
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <aio.h>
#include <errno.h>

static char buffer[CHUNK_SIZE];

long sum;
long pos, avail;

static void do_some_work(int fuel)
{
  while ((fuel > 0) && (pos < avail)) {
    sum += compute(buffer[pos], pos);
    pos++;
    fuel--;
  }
}

int main(int argc, char **argv)
{
  int i, read_iters = 0, write_iters = 0, sent;
  struct aiocb aio;
  const struct aiocb * aio_ps[1];

  starting();

  for (i = 0; i < CHUNK_COUNT; i++) {
    pos = 0;
    for (avail = 0; avail < CHUNK_SIZE; ) {
      avail += read(0, buffer + avail, CHUNK_SIZE - avail);
      read_iters++;
    }
    for (sent = 0; sent < CHUNK_SIZE; ) {
      memset(&aio, 0, sizeof(aio));
      aio.aio_fildes = 1;
      aio.aio_nbytes = CHUNK_SIZE;
      aio.aio_offset = (i * CHUNK_SIZE) + sent;
      aio.aio_buf = buffer + sent;
      aio.aio_sigevent.sigev_notify = SIGEV_NONE;
      if (aio_write(&aio)) {
        perror(strerror(errno));
        exit(1);
      }

      do_some_work(CHUNK_SIZE);

      aio_ps[0] = &aio;
      aio_suspend(aio_ps, 1, NULL);

      sent += aio_return(&aio);
      write_iters++;
    }
  }

  ending(argv[1], sum, read_iters, write_iters);

  return 0;
}
