/* Asyncornous demonstraing a callback (through a signal) to indicate
   completion. */

#include "utils.h"
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aio.h>
#include <errno.h>
#include <signal.h>

static char buffer[CHUNK_SIZE];

long sum;
long pos, avail;

static void do_some_work(int fuel)
{
  while ((fuel > 0) && (pos < avail)) {
    sum += compute(buffer[pos], pos);
    pos++;
    fuel--;
  }
}

int p[2];
void done(int v) {
  write(p[1], "x", 1);
}

int main(int argc, char **argv)
{
  int i, read_iters = 0, write_iters = 0, sent;
  struct aiocb aio;
  struct sigaction act;

  starting();

  pipe(p);
  
  act.sa_handler = done;
  act.sa_flags = 0;
  sigemptyset(&act.sa_mask);
  sigaction(SIGUSR1, &act, NULL);

  for (i = 0; i < CHUNK_COUNT; i++) {
    pos = 0;
    for (avail = 0; avail < CHUNK_SIZE; ) {
      avail += read(0, buffer + avail, CHUNK_SIZE - avail);
      read_iters++;
    }
    for (sent = 0; sent < CHUNK_SIZE; ) {
      memset(&aio, 0, sizeof(aio));
      aio.aio_fildes = 1;
      aio.aio_nbytes = CHUNK_SIZE;
      aio.aio_offset = (i * CHUNK_SIZE) + sent;
      aio.aio_buf = buffer + sent;
      aio.aio_sigevent.sigev_notify = SIGEV_SIGNAL;
      aio.aio_sigevent.sigev_signo = SIGUSR1;
      if (aio_write(&aio)) {
        perror(strerror(errno));
        exit(1);
      }

      do_some_work(CHUNK_SIZE);
      
      while (aio_error(&aio) == EINPROGRESS) {
        /* wait for signal: */
        char b[1];
        read(p[0], b, 1);
      }

      sent += aio_return(&aio);
      write_iters++;
    }
  }

  ending(argv[1], sum, read_iters, write_iters);

  return 0;
}
