/* Variant of the block strategy that interleaves read and write
   in the case of partial-block reads. Typical implementations of
   read() make this work interacively, but it's not guaranteed. */

#include "utils.h"
#include <fcntl.h>
#include <unistd.h>

static char buffer[CHUNK_SIZE];

long sum;
long pos, avail;

static void do_some_work(int fuel)
{
  while ((fuel > 0) && (pos < avail)) {
    sum += compute(buffer[pos], pos);
    pos++;
    fuel--;
  }
}

int main(int argc, char **argv)
{
  int i, read_iters = 0, write_iters = 0, sent;

  starting();
  
  for (i = 0; i < CHUNK_COUNT; i++) {
    pos = 0;
    sent = 0;
    for (avail = 0; avail < CHUNK_SIZE; ) {
      avail += read(0, buffer + avail, CHUNK_SIZE - avail);
      do_some_work(CHUNK_SIZE / 10);
      read_iters++;
      for (; sent < avail; ) {
        sent += write(1, buffer + sent, avail - sent);
        do_some_work(CHUNK_SIZE / 10);
        write_iters++;
      }
    }
    do_some_work(CHUNK_SIZE);
  }

  ending(argv[1], sum, read_iters, write_iters);

  return 0;
}
