/* Non-blocking read and write enables overlap of I/O and computation,
   especially in the case of pipelines. Read and write are not
   interleaved within a block, though, so it's not interactive. */

#include "utils.h"
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

static char buffer[CHUNK_SIZE];

long sum;
long pos, avail;

static void do_some_work(int fuel)
{
  while ((fuel > 0) && (pos < avail)) {
    sum += compute(buffer[pos], pos);
    pos++;
    fuel--;
  }
}

int main(int argc, char **argv)
{
  int i, amt, read_iters = 0, write_iters = 0, sent;
  fd_set rds, wrs;

  starting();

  fcntl(0, F_SETFL, O_NONBLOCK);
  fcntl(1, F_SETFL, O_NONBLOCK);

  for (i = 0; i < CHUNK_COUNT; i++) {
    pos = 0;
    for (avail = 0; avail < CHUNK_SIZE; ) {
      amt = read(0, buffer + avail, CHUNK_SIZE - avail);
      if (amt > 0) 
        avail += amt;
      else if (pos < avail)
        do_some_work(CHUNK_SIZE / 10);
      else {
        FD_ZERO(&rds);
        FD_SET(0, &rds);
        select(1, &rds, NULL, NULL, NULL);
      }
      read_iters++;
    }
    for (sent = 0; sent < CHUNK_SIZE; ) {
      amt = write(1, buffer + sent, CHUNK_SIZE - sent);
      if (amt > 0)
        sent += amt;
      else if (pos < avail)
        do_some_work(CHUNK_SIZE / 10);
      else {
        FD_ZERO(&wrs);
        FD_SET(0, &wrs);
        select(2, NULL, &wrs, NULL, NULL);
      }
      write_iters++;
    }
    do_some_work(CHUNK_SIZE);
  }

  ending(argv[1], sum, read_iters, write_iters);

  return 0;
}
