#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <pthread.h>
#include <netdb.h>
#include <sys/socket.h>

static int fd;

#define BUFFER_SIZE 4096

void copy(int from, int to)
{
  char buffer[BUFFER_SIZE];
  int amt, sent;

  while (1) {
    amt = read(from, buffer, BUFFER_SIZE);
    if (amt) {
      for (sent = 0; sent < amt; ) {
        sent += write(to, buffer + sent, amt - sent);
      }
    } else
      break;
  }
}

static void *copy_in(void *x)
{
  copy(0, fd);
  shutdown(fd, 1);
  return NULL;
}

static void *copy_out(void *x)
{
  copy(fd, 1);
  shutdown(fd, 0);
  return NULL;
}

int main(int argc, char **argv)
{
  int lfd, portno;
  unsigned int len;
  int reuse = 1;
  struct sockaddr_in serv_addr, addr;
  pthread_t ith, oth;

  /* Set up a server: */

  lfd = socket(AF_INET, SOCK_STREAM, 0);

  memset(&serv_addr, 0, sizeof(serv_addr));

  portno = atoi(argv[1]);
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = INADDR_ANY;
  serv_addr.sin_port = htons(portno);

  setsockopt(lfd, SOL_SOCKET, SO_REUSEADDR, (char *)(&reuse), sizeof(int));

  if (bind(lfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)))
    perror(strerror(errno));

  listen(lfd, 5);

  /* Accept a client connection: */

  fd = accept(lfd, (struct sockaddr *)&addr, &len);

  /* Copy stdin to fd, fd to stdout: */
  pthread_create(&ith, NULL, copy_in, NULL);
  pthread_create(&oth, NULL, copy_out, NULL);

  pthread_join(ith, NULL);
  pthread_join(oth, NULL);

  return 0;
}
