#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <fcntl.h>
#include <sys/socket.h>

static int fd;

#define BUFFER_SIZE 4096

static int try_copy(int from, int to, 
                    char *buffer, int *avail, int *off,
                    fd_set *rds, fd_set *wrs)
/* Result: 0 => no more data to transfer
           1 => more data, but need select
           2 => more data, try again immediately */
{
  int amt;

  if (*avail == -1)
    return 0;

  if (!*avail) {
    *off = 0;
    amt = read(from, buffer, BUFFER_SIZE);
    if (amt < 0)
      FD_SET(from, rds);
    else if (amt) {
      *avail = amt;
    } else {
      *avail = -1;
      shutdown(fd, (fd == to) ? 1 : 0);
      return 0;
    }
  }

  if (*avail) {
    amt = write(to, buffer + *off, *avail);
    if (amt < 0)
      FD_SET(from, wrs);
    else if (amt) {
      *off += amt;
      *avail -= amt;
      return 2;
    }
  }

  return 1;
}

int main(int argc, char **argv)
{
  int lfd, portno;
  unsigned int len;
  int reuse = 1;
  struct sockaddr_in serv_addr, addr;
  char ibuffer[BUFFER_SIZE];
  char obuffer[BUFFER_SIZE];
  int iavail = 0, ioff = 0, more_in;
  int oavail = 0, ooff = 0, more_out;
  fd_set rds, wrs;

  /* Set up a server: */

  lfd = socket(AF_INET, SOCK_STREAM, 0);

  memset(&serv_addr, 0, sizeof(serv_addr));

  portno = atoi(argv[1]);
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = INADDR_ANY;
  serv_addr.sin_port = htons(portno);

  setsockopt(lfd, SOL_SOCKET, SO_REUSEADDR, (char *)(&reuse), sizeof(int));

  if (bind(lfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)))
    perror(strerror(errno));

  listen(lfd, 5);

  /* Accept a client connection: */

  fd = accept(lfd, (struct sockaddr *)&addr, &len);

  fcntl(0, F_SETFL, O_NONBLOCK);
  fcntl(1, F_SETFL, O_NONBLOCK);
  fcntl(fd, F_SETFL, O_NONBLOCK);

  /* Copy stdin to fd, fd to stdout: */
  while (1) {    
    FD_ZERO(&rds);
    FD_ZERO(&wrs);

    more_in = try_copy(0, fd, ibuffer, &iavail, &ioff, &rds, &wrs);
    more_out = try_copy(fd, 1, obuffer, &oavail, &ooff, &rds, &wrs);

    if (!more_in && !more_out)
      /* no more data */
      break;

    if ((more_in < 2) && (more_out < 2))
      /* need to select for both */
      select(fd+1, &rds, &wrs, NULL, NULL);
  }

  return 0;
}
