/* Put the non-I/O computation in its own thread, which allows it to
   proceed in parallel to I/O. */

#include "utils.h"
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/times.h>
#include <pthread.h>

static char buffer[CHUNK_SIZE];

long sum;
long pos, avail;

static pthread_mutex_t avail_m = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t more_avail = PTHREAD_COND_INITIALIZER;

static void *work(void *p)
{
  long now_avail;

  while (pos < CHUNK_SIZE) {
    pthread_mutex_lock(&avail_m);
    while (avail <= pos)
      pthread_cond_wait(&more_avail, &avail_m);
    now_avail = avail;
    pthread_mutex_unlock(&avail_m);
    
    while (pos < now_avail) {
      sum += compute(buffer[pos], pos);
      pos++;
    }
  }

  return NULL;
}

int main(int argc, char **argv)
{
  int i, read_iters = 0, write_iters = 0, sent, amt;

  starting();

  for (i = 0; i < CHUNK_COUNT; i++) {
    pthread_t th;

    pos = 0;
    avail = 0;
    pthread_create(&th, NULL, work, NULL);

    for (; avail < CHUNK_SIZE; ) {
      amt = read(0, buffer + avail, CHUNK_SIZE - avail);
      pthread_mutex_lock(&avail_m);
      avail += amt;
      pthread_cond_signal(&more_avail);
      pthread_mutex_unlock(&avail_m);
      read_iters++;
    }
    for (sent = 0; sent < CHUNK_SIZE; ) {
      sent += write(1, buffer + sent, CHUNK_SIZE - sent);
      write_iters++;
    }

    pthread_join(th, NULL);
  }

  ending(argv[1], sum, read_iters, write_iters);

  return 0;
}
