/* Put each of I and O in its own thread, which allows it to proceed
   in parallel to computation. Typical read() implementations also
   make the streaming interactive. */

#include "utils.h"
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/times.h>
#include <pthread.h>

static char buffer[CHUNK_SIZE];

long sum;
long pos, avail;

static pthread_mutex_t avail_m = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t more_avail = PTHREAD_COND_INITIALIZER;

static int read_iters, write_iters;

void *reader(void *x)
{
  int amt;

  for (; avail < CHUNK_SIZE; ) {
    amt = read(0, buffer + avail, CHUNK_SIZE - avail);
    pthread_mutex_lock(&avail_m);
    avail += amt;
    pthread_cond_broadcast(&more_avail);
    pthread_mutex_unlock(&avail_m);
    read_iters++;
  }

  return NULL;
}

void *writer(void *x)
{
  int sent = 0;
  long now_avail;

  while (sent < CHUNK_COUNT) {
    pthread_mutex_lock(&avail_m);
    while (avail <= sent)
      pthread_cond_wait(&more_avail, &avail_m);
    now_avail = avail;
    pthread_mutex_unlock(&avail_m);

    for (; sent < now_avail; ) {
      sent += write(1, buffer + sent, now_avail - sent);
      write_iters++;
    }
  }

  return NULL;
}


int main(int argc, char **argv)
{
  int i;
  long now_avail;  

  starting();

  for (i = 0; i < CHUNK_COUNT; i++) {
    pthread_t ith, oth;

    pos = 0;
    avail = 0;
    pthread_create(&ith, NULL, reader, NULL);
    pthread_create(&oth, NULL, writer, NULL);

    while (pos < CHUNK_SIZE) {
      pthread_mutex_lock(&avail_m);
      while (avail <= pos)
        pthread_cond_wait(&more_avail, &avail_m);
      now_avail = avail;
      pthread_mutex_unlock(&avail_m);
      
      while (pos < now_avail) {
        sum += compute(buffer[pos], pos);
        pos++;
      }
    }

    pthread_join(ith, NULL);
    pthread_join(oth, NULL);
  }

  ending(argv[1], sum, read_iters, write_iters);

  return 0;
}
