#include "utils.h"
#include <stdio.h>
#include <sys/times.h>

/* simulate real work: */
int compute(int v, int pos) {
  int r = 1;
  while (v > 1) {
    r *= v;
    v /= 2;
  }
  return r * pos;
}

/* Tracking compute time and reporting results */

static clock_t start, end;

void starting()
{
  struct tms t;
  start = times(&t);
}

void ending(char *name, long sum, int read_iters, int write_iters)
{
  struct tms t;

  end = times(&t);
  fprintf(stderr, 
          "%s: %lx  %lds + %ldu = %ldcpu / %ldreal  retires: %drd %dwr\n", 
          name,
          sum,
          t.tms_stime, 
          t.tms_utime, 
          t.tms_stime + t.tms_utime,
          end - start,
          read_iters - CHUNK_COUNT,
          write_iters - CHUNK_COUNT);
}
