#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <sys/socket.h>

int main(int argc, char **argv, char **envp)
{
  int s, portno, amt, got;
  struct hostent *server;
  struct sockaddr_in serv_addr;

  if (argc < 4) {
    perror("need <hostname> <port> <message> [<sleep>]");
    return 1;
  }
  
  server = gethostbyname(argv[1]);
  if (!server) {
    perror("hostname lookup failed");
    return 1;
  }
  portno = atoi(argv[2]);
                
  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  memcpy(&serv_addr.sin_addr.s_addr, server->h_addr, server->h_length);
  serv_addr.sin_port = htons(portno);
      
  s = socket(PF_INET, SOCK_STREAM, getprotobyname("tcp")->p_proto);

  if (connect(s, (const struct sockaddr *)&serv_addr, sizeof(serv_addr))) {
    perror("connect failed");
    return 1;
  }
  
  amt = write(s, argv[3], strlen(argv[3]));
  if (amt < 0) {
    perror("write failed");
    return 1;
  }

  got = 0;
  amt = read(s, &got, sizeof(got));
  printf("server got %d\n", got);

  if (argc > 4) {
    int seconds;
    seconds = atoi(argv[4]);
    sleep(seconds);
  }

  /* intentionally omitted: close(s); */
  
  return 0;
}
