#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <sys/socket.h>

int main(int argc, char **argv, char **envp)
{
  int s, portno, amt;
  struct hostent *server;
  struct sockaddr_in serv_addr;
  char buffer[32];

  if (argc < 4) {
    perror("need <hostname> <port> <message> [<sleep>]");
    return 1;
  }
  
  server = gethostbyname(argv[1]);
  if (!server) {
    perror("hostname lookup failed");
    return 1;
  }
  portno = atoi(argv[2]);
                
  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  memcpy(&serv_addr.sin_addr.s_addr, server->h_addr, server->h_length);
  serv_addr.sin_port = htons(portno);
      
  s = socket(PF_INET, SOCK_STREAM, getprotobyname("tcp")->p_proto);

  if (connect(s, (const struct sockaddr *)&serv_addr, sizeof(serv_addr))) {
    perror("connect failed");
    return 1;
  }
  
  amt = write(s, argv[3], strlen(argv[3]));
  if (amt < 0) {
    perror("write failed");
    return 1;
  }

  shutdown(s, SHUT_WR);

  amt = read(s, buffer, 2);
  printf("server said %2.2s\n", buffer);

  close(s);
  
  return 0;
}
