#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <sys/socket.h>

#define BUFFER_SIZE 1024

int main(int argc, char **argv)
{
  int ls, s, portno, amt;
  unsigned int len;
  struct sockaddr_in serv_addr, addr;
  char buffer[BUFFER_SIZE];

  ls = socket(AF_INET, SOCK_STREAM, getprotobyname("tcp")->p_proto);

  memset(&serv_addr, 0, sizeof(serv_addr));

  portno = atoi(argv[1]);
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = INADDR_ANY;
  serv_addr.sin_port = htons(portno);

  if (bind(ls, (struct sockaddr *)&serv_addr, sizeof(serv_addr))) {
    perror(strerror(errno));
    return 1;
  }

  listen(ls, 5);

  while (1) {
    s = accept(ls, (struct sockaddr *)&addr, &len);

    while (1) {
      amt = recv(s, buffer, BUFFER_SIZE, 0);
      if (amt < 0) {
        perror("recv failed\n");
        break;
      } else if (amt == 0) {
        printf("client is done\n");
        write(s, "ok", 2);
        break;
      } else {
        write(1, buffer, amt);
        write(1, "\n", 1);
      }
    }
    close(s);
  }

  return 0;
}
