#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <sys/socket.h>

int main(int argc, char **argv, char **envp)
{
  int s, portno, amt;
  struct hostent *server;
  struct sockaddr_in addr, serv_addr;

  if (argc < 5) {
    perror("need <port> <hostname> <port> <message>");
    return 1;
  }
  
  memset(&addr, 0, sizeof(addr));
  portno = atoi(argv[1]);
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = htons(portno);
                
  server = gethostbyname(argv[2]);
  if (!server) {
    perror("hostname lookup failed");
    return 1;
  }
  portno = atoi(argv[3]);

  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  memcpy(&serv_addr.sin_addr.s_addr, server->h_addr, server->h_length);
  serv_addr.sin_port = htons(portno);

  printf("host is %d.%d.%d.%d\n",
         ((unsigned char *)&serv_addr.sin_addr.s_addr)[0],
         ((unsigned char *)&serv_addr.sin_addr.s_addr)[1],
         ((unsigned char *)&serv_addr.sin_addr.s_addr)[2],
         ((unsigned char *)&serv_addr.sin_addr.s_addr)[3]);
      
  s = socket(PF_INET, SOCK_DGRAM, getprotobyname("udp")->p_proto);
  if (bind(s, (struct sockaddr *)&addr, sizeof(addr)))
    perror("bind failed");
  amt = sendto(s, argv[4], strlen(argv[4]), 0,
               (const struct sockaddr *)&serv_addr, sizeof(serv_addr));
  if (amt < 0)
    perror("sendto failed");
  
  return (amt != strlen(argv[3]));
}
