#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <sys/socket.h>

int main(int argc, char **argv, char **envp)
{
  int s, portno, amt, i, len;
  struct hostent *server;
  struct sockaddr_in serv_addr;
  char buffer[1024];

  if (argc < 4) {
    perror("need <hostname> <port> <message>");
    return 1;
  }
  
  server = gethostbyname(argv[1]);
  if (!server) {
    perror("hostname lookup failed");
    return 1;
  }
  portno = atoi(argv[2]);
                
  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  memcpy(&serv_addr.sin_addr.s_addr, server->h_addr, server->h_length);
  serv_addr.sin_port = htons(portno);

  s = socket(PF_INET, SOCK_DGRAM, getprotobyname("udp")->p_proto);
  if (connect(s, (const struct sockaddr *)&serv_addr, sizeof(serv_addr))) {
    perror("connect failed");
    return 1;
  }
    

  for (i = 0; i < 50; i++) {
    strcpy(buffer, argv[3]);
    len = strlen(buffer);
    buffer[len++] = (i / 10) + '0';
    buffer[len++] = (i % 10) + '0';
    amt = send(s, buffer, len, 0);
    if (amt < 0) {
      perror("sendto failed");
      return 1;
    }
  }
  
  return (amt != strlen(argv[3]));
}
