#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <sys/socket.h>

#define BUFFER_SIZE 1024

int main(int argc, char **argv)
{
  int s, portno;
  int amt;
  unsigned int from_len;
  struct sockaddr_in addr, from_addr;
  char buffer[BUFFER_SIZE];

  s = socket(AF_INET, SOCK_DGRAM, getprotobyname("udp")->p_proto);

  memset(&addr, 0, sizeof(addr));

  portno = atoi(argv[1]);
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = htons(portno);

  if (bind(s, (struct sockaddr *)&addr, sizeof(addr)))
    perror(strerror(errno));

  while (1) {
    from_len = sizeof(from_addr);
    amt = recvfrom(s, buffer, BUFFER_SIZE, 0,
                   (struct sockaddr *)&from_addr, &from_len);
    if (amt >= 0) {
      write(1, buffer, amt);
      printf("\n from %d.%d.%d.%d %d\n",
             ((unsigned char *)&from_addr.sin_addr.s_addr)[0],
             ((unsigned char *)&from_addr.sin_addr.s_addr)[1],
             ((unsigned char *)&from_addr.sin_addr.s_addr)[2],
             ((unsigned char *)&from_addr.sin_addr.s_addr)[3],
             ntohs(from_addr.sin_port));
    }
  }

  return 0;
}
