#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char **argv, char **env){
  pid_t child_pid;
  int ifds[2], ofds[2];

  pipe(ifds);
  pipe(ofds);

  child_pid = fork();
  if (!child_pid) {
    /* child */
    char *argv2[4];

    close(ifds[1]);
    dup2(ifds[0], 0);

    close(ofds[0]);
    dup2(ofds[1], 1);

    argv2[0] = "echo_child";
    argv2[1] = argv[1];
    argv2[2] = argv[2];
    argv2[3] = NULL;

    execve(argv2[0], argv2, env);
  } else {
    /* parent */
    int sz, i;
    char *data;
    FILE *to, *from;
    
    close(ofds[1]);
    close(ifds[0]);

    to = fdopen(ifds[1], "a");
    from = fdopen(ofds[0], "r");

    sz = atoi(argv[1]);
    data = malloc(sz);
    memset(data, 'x', sz);

    while (1) {
      fwrite(data, sz, 1, to);
      fflush(to);
      fread(data, sz, 1, from);
      printf("got it\n");
    }

    return 0;
  }
}
