#include <unistd.h>
#include <sys/wait.h>
#include <stdio.h>

int main(int argc, char **argv, char **env){
  pid_t child_pid;

  child_pid = fork();
  if (!child_pid) {
    /* child */
    char *argv2[3];

    argv2[0] = "fork_child";
    argv2[1] = argv[2];
    argv2[2] = NULL;

    execve(argv2[0], argv2, env);
  } else {
    /* parent */
    pid_t pid;
    int status;

    printf("parent %s\n", argv[1]);
    pid = wait(&status);
    printf("child %d (= %d ?) done %d\n", 
           pid, child_pid, 
           WEXITSTATUS(status));

    return 0;
  }
}
