#include <pthread.h>
#include <stdio.h>

/****************************************/
/* Pthread Mutex lock:                  */

static pthread_mutex_t m = PTHREAD_MUTEX_INITIALIZER;

static void lock(int self)
{
  pthread_mutex_lock(&m);
}

static void unlock(int self)
{
  pthread_mutex_unlock(&m);
}
 

/****************************************/
 
static int count = 10000000;
volatile int total = 0;

void *inc(void *x)
{
  int i, j, id = *(int *)x;
  for (j = 0; j < 10; j++) {
    lock(id);
    for (i = 0; i < count; i++)
      total++;
    unlock(id);
  }
  
  return NULL;
}

int main(void)
{
  pthread_t t[4];
  int id[4] = { 0, 1, 2, 3 };

  pthread_create(&t[0], NULL, inc, &id[0]);
  pthread_create(&t[1], NULL, inc, &id[1]);
  pthread_create(&t[2], NULL, inc, &id[2]);
  pthread_create(&t[3], NULL, inc, &id[3]);
  
  puts("Waiting for threads...");
  pthread_join(t[0], NULL);
  pthread_join(t[1], NULL);
  pthread_join(t[2], NULL);
  pthread_join(t[3], NULL);
  
  printf("Done: %d\n", total);
  
  return 0;
}
