#include <pthread.h>
#include <stdio.h>

/****************************************/
/* Compare-and-swap lock:               */

static inline int cmpswap(int *ptr, int old, int new)
{
  /* cmpxchgl compares EAX (= `old') with the value at the address 
     given by the second argument (= `ptr'); if they match, it moves the
     first argument (= `new') into the second argument `(= `ptr'); if
     they do not match, it moves the value in the second argument 
     (= `ptr') into EAX. This function returns the ending value of EAX; 
     which is either `old' or the actual old value. */
  asm volatile("lock cmpxchgl %1,%2" 
               : "=a" (old)  /* get `old' result from EAX */
               : "q" (new),  /* %1 is register containing `new' */
                 "m" (*ptr), /* %2 refers to memory location */
                 "0" (old)   /* init result regsister (= EAX) to `old' */
               : "memory");
  return old;
}

static int lock_on = 0;

static void lock(int self)
{
  while (cmpswap(&lock_on, 0, self + 1) != 0);
}

static void unlock(int self)
{
  lock_on = 0;
}
 

/****************************************/
 
static int count = 10000000;
volatile int total = 0;

void *inc(void *x)
{
  int i, j, id = *(int *)x;

  for (j = 0; j < 10; j++) {
    lock(id);
    for (i = 0; i < count; i++)
      total++;
    unlock(id);
  }
  
  return NULL;
}

int main(void)
{
  pthread_t t[2];
  int id[2] = { 0, 1 };

  pthread_create(&t[0], NULL, inc, &id[0]);
  pthread_create(&t[1], NULL, inc, &id[1]);
  
  puts("Waiting for threads...");
  pthread_join(t[0], NULL);
  pthread_join(t[1], NULL);
  
  printf("Done: %d\n", total);
  
  return 0;
}
