#include <pthread.h>
#include <stdio.h>

/****************************************/
/* Peterson's algorithm:                */

volatile int flag[2];
volatile int turn;

static void lock(int self)
{
  flag[self] = 1;
  turn = !self;
  while (flag[!self] && turn == !self);
}

static void unlock(int self)
{
  flag[self] = 0; 
}

/****************************************/
 
static int count = 10000000;
volatile int total = 0;

void *inc(void *x)
{
  int i, id = *(int *)x;
  for (i = 0; i < count; i++) {
    lock(id);
    total++;
    unlock(id);
  }
  
  return NULL;
}

int main(void)
{
  pthread_t t[2];
  int id[2] = { 0, 1 };

  pthread_create(&t[0], NULL, inc, &id[0]);
  pthread_create(&t[1], NULL, inc, &id[1]);
  
  puts("Waiting for threads...");
  pthread_join(t[0], NULL);
  pthread_join(t[1], NULL);
  
  printf("Done: %d\n", total);
  
  return 0;
}
