#include <pthread.h>
#include <stdio.h>
#include "compute.h"

/****************************************/
/* Pthread Mutex lock:                  */

static pthread_mutex_t m = PTHREAD_MUTEX_INITIALIZER;

static void lock()
{
  pthread_mutex_lock(&m);
}

static void unlock()
{
  pthread_mutex_unlock(&m);
}
 
/****************************************/

static int produced_value;
 
static void *producer(void *x)
{
  int value = 0;

  while (1) {
    value = simulate_compute(value + 1, 0.5);
    
    lock();
    produced_value = value;
    unlock();
  }
  
  return NULL;
}

static void *consumer(void *x)
{
  int value;

  while (1) {
    do {
      lock();
      value = produced_value;
      produced_value = 0;
      unlock();
    } while (value == 0);

    printf("Got %d\n", value);
  }
  
  return NULL;
}

int main(void)
{
  pthread_t t[2];

  pthread_create(&t[0], NULL, producer, NULL);
  pthread_create(&t[1], NULL, consumer, NULL);
  
  puts("Waiting for threads...");
  pthread_join(t[0], NULL);
  pthread_join(t[1], NULL);
  
  return 0;
}
