#include <pthread.h>
#include <stdio.h>
#include "compute.h"

/*****************************************/
/* Semaphores implemented with mutex and */
/* conditions: */

typedef struct sema_t {
  int ready;
  pthread_mutex_t m;
  pthread_cond_t c;
} sema_t;

#define SEMA_INITIALIZER { 0, PTHREAD_MUTEX_INITIALIZER, \
                           PTHREAD_COND_INITIALIZER }

static void sema_wait(sema_t *s)
{
  pthread_mutex_lock(&s->m);
  while (!s->ready) {
    pthread_cond_wait(&s->c, &s->m);
  }
  --s->ready;
  pthread_mutex_unlock(&s->m);
}

static void sema_signal(sema_t *s)
{
  pthread_mutex_lock(&s->m);
  s->ready++;
  pthread_cond_signal(&s->c);
  pthread_mutex_unlock(&s->m);
}

/****************************************/

static sema_t full_s = SEMA_INITIALIZER;
static sema_t empty_s = SEMA_INITIALIZER;

static int produced_value;
 
static void *producer(void *x)
{
  int value = 0;

  while (1) {
    value = simulate_compute(value + 1, 0.5);
    sema_wait(&empty_s);
    produced_value = value;
    sema_signal(&full_s);
  }
  
  return NULL;
}

static void *consumer(void *x)
{
  while (1) {
    sema_wait(&full_s);
    printf("Got %d\n", produced_value);
    sema_signal(&empty_s);
  }
  
  return NULL;
}

int main(void)
{
  pthread_t t[3];

  sema_signal(&empty_s);

  pthread_create(&t[0], NULL, producer, NULL);
  pthread_create(&t[1], NULL, producer, NULL);
  pthread_create(&t[2], NULL, consumer, NULL);
  
  puts("Waiting for threads...");
  pthread_join(t[0], NULL);
  pthread_join(t[1], NULL);
  pthread_join(t[2], NULL);
  
  return 0;
}
