#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <sys/time.h>

volatile int a, b, timeouts;
volatile int need_reset = 1;

void timeout(int v) {
  timeouts++;
  a++;
  b--;
  need_reset = 1;
}

static void start_timer() {
  struct itimerval it;
  int sec = 0;
  int usec = 10000;
  
  it.it_value.tv_sec = sec;
  it.it_value.tv_usec = usec;
  it.it_interval.tv_sec = sec;
  it.it_interval.tv_usec = usec;
  
  if (setitimer(ITIMER_REAL, &it, NULL)) {
    perror ("\n\noops -- setitimer failed");
    exit(1);
  }

  need_reset = 0;
}

int main () {
  struct sigaction act;
    
  act.sa_handler = timeout;
  act.sa_flags = 0;
  sigemptyset(&act.sa_mask);
  if (sigaction(SIGALRM, &act, NULL)) {
    perror ("\n\noops -- sigaction failed");
    exit(1);
  }  

  while (a < 100000000) {
    if (need_reset)
      start_timer();
    a++;
    b--;
  }

  printf("%d %d\n", b, timeouts);
  return 0;
}
