#include <sys/mman.h>
#include <stdio.h>
#include <unistd.h>

static int page_size;

void *alloc_pages(long start, int sz)
{
  void *p;

  p = mmap((void *)start,
           sz, 
           PROT_READ | PROT_WRITE,
           MAP_ANON | MAP_SHARED,
           -1, 
           0);

  if (p == MAP_FAILED)
    perror("mmap failed");

  return p;
}

int main()
{
  void *a;
  pid_t pid;

  page_size = getpagesize();
  
  a = alloc_pages(0, page_size);

  *(int *)a = 1;
  pid = fork();
  if (!pid) {
    printf("Child pre: %d\n", *(int *)a);
    *(int *)a = 2;
    printf("Child post: %d\n", *(int *)a);
    return 0;
  } else {
    int res;
    waitpid(pid, &res, 0);
    printf("Parent post: %d\n", *(int *)a);
  }

  return 0;
}
