#include <sys/mman.h>
#include <stdio.h>
#include <unistd.h>

static int page_size;

void *alloc_pages(long start, int sz)
{
  void *p;

  p = mmap((void *)start,
           sz, 
           PROT_READ | PROT_WRITE,
           MAP_PRIVATE | MAP_ANON | MAP_FIXED,
           -1, 
           0);

  if (p == MAP_FAILED)
    perror("mmap failed");

  return p;
}

int main()
{
  void *a, *b, *c;

  page_size = getpagesize();
  
  a = alloc_pages(0, page_size);
  b = alloc_pages(0x200008000, page_size * 2);
  c = alloc_pages(0x200009000, page_size); /* replaces */

  printf("size 0x%x; allocated at %p, %p, %p\n", 
         page_size,
         a, b, c);

  /* If allocation of `a' succeeded, so will this: */
  printf("At NULL: %d\n", *(int *)NULL);

  return 0;
}
