#include <sys/mman.h>
#include <stdio.h>
#include <unistd.h>

static int page_size;

void *alloc_pages(long start, int sz)
{
  void *p;

  p = mmap((void *)start,
           sz, 
           PROT_READ, /* no PROT_WRITE ! */
           MAP_PRIVATE | MAP_ANON,
           -1, 
           0);

  if (p == MAP_FAILED)
    perror("mmap failed");

  return p;
}

int main()
{
  void *a;
  pid_t pid;

  page_size = getpagesize();
  
  a = alloc_pages(0, 2 * page_size);

  printf("pre: %d\n", ((char *)a)[0]);
  // mprotect(a, page_size, PROT_READ | PROT_WRITE);
  ((char *)a)[0] = 1;
  printf("post: %d\n", ((char *)a)[0]);
  
  return 0;
}
