#include <stdlib.h>
#include <time.h>
#include <rpc/rpc.h>
#include "field.h"
#include "const.h"
#include "rand.h"

static rand_state_t r;

/**********************************************************************/
/* Ball-transfer contest                                              */

static int contest()
/* Generate a bunch of random numbers to determine whether a
   pass/steal succeeds. (Simulates a more interesting calculation that
   a real game might use.) */
{
  int c1 = 0, c2 = 0;

  while ((c1 < 10000) && (c2 < 10000)) {
    if (bsd_rand(100, &r) > bsd_rand(100, &r))
      c1++;
    else
      c2++;
  }

  return (c1 > c2);
}

/**********************************************************************/
/* Locks                                                              */

/* Pretend that we do not need a lock... */

static void lock_field() { }
static void unlock_field() { }

/**********************************************************************/
/* The player thread's procedure                                      */

void run_player(int p, CLIENT *cl)
{
  int p2;

  while (1) {
    int x, y;

    x = *get_player_x_1(p, cl);
    y = *get_player_y_1(p, cl);
    switch (bsd_rand(4, &r)) {
    case 0: x++; break;
    case 1: --x; break;
    case 2: y++; break;
    case 3: y--; break;
    }
     
    if ((x >= 0) && (x < HSIZE)
        && (y >= 0) && (y < VSIZE)) {
      lock_field();
      
      p2 = *get_field_player_1(y, x, cl);
      if (!p2) {
        move_player_1(p, y, x, cl);
      } else {
        if (*get_player_ball_1(p, cl) 
            && (*get_player_team_1(p, cl) == *get_player_team_1(p2, cl)) 
            && !*get_player_ball_1(p2, cl)) {
          /* try to pass */
          if (contest()) {
            move_ball_1(p, p2, 1, cl);
          }
        } else if (!*get_player_ball_1(p, cl)
                   && (*get_player_team_1(p, cl) != *get_player_team_1(p2, cl))
                   && *get_player_ball_1(p2, cl)) {
          /* try to steal... */
          if (contest()) {
            /* a steal */
            move_ball_1(p2, p, 0, cl);
          }
        } else {
          /* bump */
        }
      }
      unlock_field();
    }
  }
}

/**********************************************************************/
/* Startup                                                            */

int main(int argc, char **argv)
{
  CLIENT *cl;
  int mix, p;

  cl = clnt_create(argv[1], FIELD, FIELDVERS, "tcp"); 
  if (cl == NULL) {
    clnt_pcreateerror(argv[1]);
    return 1;
  }

  mix = (int)time(NULL);
  bsd_srand(mix, &r);

  p = atoi(argv[2]);

  init_field_1(p, cl);

  run_player(p, cl);
    
  return 0;
}
