#include "rand.h"

/**********************************************************************/
/* Random-number generator                                            */

/* This is a stripped-down version of random.c as distributed with
   FreeBSD 2.2 */

int bsd_rand(int n, rand_state_t *r)
{
  int i;
  
  r->state[r->fpos] += r->state[r->rpos];
  i = (r->state[r->fpos] >> 1) & 0x7fffffff; /* chucking least random bit */
  if (++(r->fpos) >= DEG) {
    r->fpos = 0;
    r->rpos++;
  } else if (++(r->rpos) >= DEG)
    r->rpos = 0;

  return i % n;
}

void bsd_srand(int x, rand_state_t *r)
{
  register int i;

  r->state[0] = x & 0x7fffffff;
  for (i = 1; i < DEG; i++) {
    register long hi, lo, v;
  
    v = r->state[i - 1];
    hi = v / 127773;
    lo = v % 127773;
    v = 16807 * lo - 2836 * hi;
    if (v <= 0)
      v += 0x7fffffff;
    r->state[i] = v;
  }
  r->fpos = SEP;
  r->rpos = 0;
  for (i = 0; i < 10 * DEG; i++) {
    (void)bsd_rand(1, r);
  }
}

